# Open Source Software Compliance Artifact

## Software Bill of Materials (SBOM)

| Component Name    | Version         | Supplier     | License    | Copyright Info                     | Download Location           | OSS Modification | OSS Source Code Disclosure | OSS Usage Method |
|-------------------|-----------------|--------------|------------|------------------------------------|-----------------------------|------------------|----------------------------|------------------|
| U-Boot            | 2015.1          | DENX         | GPLv2      | Copyright (c) Wolfgang Denk, DENX Software Engineering | https://github.com/u-boot/u-boot | Modified | Required | Modified GPLv2 component - derivative work must be licensed under GPLv2 |
| Linux Kernel      | 4.9.227         | YUYAO SUNNY OPTICAL INTELLIGENCE TECHNOLOGY CO.,LTD | GPLv2      | Copyright (c) Linux Kernel Organization | https://www.kernel.org/ | Modified | Required | Modified GPLv2 component - derivative work must be licensed under GPLv2 |
| BusyBox           | 1.20.2          | BusyBox      | GPLv2      | Copyright (c) Various contributors | https://busybox.net/downloads/ | Not Modified | Not Applicable | GPLv2 component (unmodified) - derivative work must be licensed under GPLv2 |
| SquashFS          | 4.1             | SquashFS project | GPLv2      | Copyright (c) Phillip Lougher | https://github.com/plougher/squashfs-tools | Not Modified | Not Applicable | GPLv2 component (unmodified) - derivative work must be licensed under GPLv2 |
| libcomposite      | 4.9.227         | The Linux Foundation | GPLv2      | Copyright (c) Linux Kernel Organization | - | Included in Linux Kernel | Required |GPLv2 component integrated with modified Linux Kernel |
| MI System Libraries | 1.0.0          | SigmaStar Technology | Proprietary | Copyright (c) SigmaStar Technology | - | Not Modified | Not Applicable | Proprietary component with separate commercial license (System Libraries) |
| MI Algorithm Libraries | 1.0.0       | SigmaStar Technology | Proprietary | Copyright (c) SigmaStar Technology | - | Not Modified | Not Applicable | Proprietary component with separate commercial license (Algorithm Libraries) |
| MI Codec Libraries | 1.0.0          | SigmaStar Technology | Proprietary | Copyright (c) SigmaStar Technology | - | Not Modified | Not Applicable | Proprietary component with separate commercial license (Codec Libraries) |
| glibc             | 2.30            | GNU Project  | LGPLv2.1   | Copyright (c) Free Software Foundation |gcc-sigmastar-9.1.0-2020.07-x86_64_arm-linux-gnueabihf https://www.linaro.org/  | Not Modified | Not Applicable | Dynamic linking with proprietary software (compliant with LGPLv2.1 - no source disclosure required) |
| libm        | 2.30            | GNU Project  | LGPLv2.1   | Copyright (c) Free Software Foundation |gcc-sigmastar-9.1.0-2020.07-x86_64_arm-linux-gnueabihf https://www.linaro.org/  | Not Modified | Not Applicable | Dynamic linking with proprietary software (compliant with LGPLv2.1 - no source disclosure required) |
| libpthread  | 2.30            | GNU Project  | LGPLv2.1   | Copyright (c) Free Software Foundation |gcc-sigmastar-9.1.0-2020.07-x86_64_arm-linux-gnueabihf https://www.linaro.org/  | Not Modified | Not Applicable | Dynamic linking with proprietary software (compliant with LGPLv2.1 - no source disclosure required) |
| libdl       | 2.30            | GNU Project  | LGPLv2.1   | Copyright (c) Free Software Foundation |gcc-sigmastar-9.1.0-2020.07-x86_64_arm-linux-gnueabihf https://www.linaro.org/  | Not Modified | Not Applicable | Dynamic linking with proprietary software (compliant with LGPLv2.1 - no source disclosure required) |
| librt       | 2.30            | GNU Project  | LGPLv2.1   | Copyright (c) Free Software Foundation |gcc-sigmastar-9.1.0-2020.07-x86_64_arm-linux-gnueabihf https://www.linaro.org/  | Not Modified | Not Applicable | Dynamic linking with proprietary software (compliant with LGPLv2.1 - no source disclosure required) |
| libutil     | 2.30            | GNU Project  | LGPLv2.1   | Copyright (c) Free Software Foundation |gcc-sigmastar-9.1.0-2020.07-x86_64_arm-linux-gnueabihf https://www.linaro.org/  | Not Modified | Not Applicable | Dynamic linking with proprietary software (compliant with LGPLv2.1 - no source disclosure required) |
| libnss_files      | 2.30            | GNU Project  | LGPLv2.1   | Copyright (c) Free Software Foundation |gcc-sigmastar-9.1.0-2020.07-x86_64_arm-linux-gnueabihf https://www.linaro.org/  | Not Modified | Not Applicable | Dynamic linking with proprietary software (compliant with LGPLv2.1 - no source disclosure required) |
| libresolv         | 2.30            | GNU Project  | LGPLv2.1   | Copyright (c) Free Software Foundation |gcc-sigmastar-9.1.0-2020.07-x86_64_arm-linux-gnueabihf https://www.linaro.org/  | Not Modified | Not Applicable | Dynamic linking with proprietary software (compliant with LGPLv2.1 - no source disclosure required) |
| libnss_compat     | 2.30            | GNU Project  | LGPLv2.1   | Copyright (c) Free Software Foundation |gcc-sigmastar-9.1.0-2020.07-x86_64_arm-linux-gnueabihf https://www.linaro.org/  | Not Modified | Not Applicable | Dynamic linking with proprietary software (compliant with LGPLv2.1 - no source disclosure required) |
| libcrypt          | 2.30            | GNU Project  | LGPLv2.1   | Copyright (c) Free Software Foundation |gcc-sigmastar-9.1.0-2020.07-x86_64_arm-linux-gnueabihf https://www.linaro.org/  | Not Modified | Not Applicable | Dynamic linking with proprietary software (compliant with LGPLv2.1 - no source disclosure required) |
| libstdc++         | 9.1.0           | GNU Project  | GPLv3+     | Copyright (c) Free Software Foundation | gcc-sigmastar-9.1.0-2020.07-x86_64_arm-linux-gnueabihf https://www.linaro.org/  | Not Modified | Not Applicable | Dynamic linking with proprietary software (compliant with GPLv3+ Runtime Library Exception - no source disclosure required) |
| libc6             | 2.30            | GNU Project  | LGPLv2.1   | Copyright (c) Free Software Foundation |gcc-sigmastar-9.1.0-2020.07-x86_64_arm-linux-gnueabihf https://www.linaro.org/  | Not Modified | Not Applicable | Dynamic linking with proprietary software (compliant with LGPLv2.1 - no source disclosure required) |
| libgcc-s1         | 9.1.0           | GNU Project  | GPLv3+ with GCC Runtime Library Exception | Copyright (c) Free Software Foundation | gcc-sigmastar-9.1.0-2020.07-x86_64_arm-linux-gnueabihf https://www.linaro.org/  | Not Modified | Not Applicable | Dynamic linking with proprietary software (compliant with GPLv3+ Runtime Library Exception - no source disclosure required) |
| libz              | 1.2.11          | zlib         | zlib       | Copyright (c) Jean-loup Gailly and Mark Adler | https://github.com/madler/zlib | Not Modified | Not Applicable | zlib License - proprietary integration allowed with copyright notice preservation |
| libfuse           | 2.9.1           | libfuse      | LGPLv2.1   | Copyright (c) Miklos Szeredi | https://github.com/libfuse/libfuse | Not Modified | Not Applicable | Dynamic linking with proprietary software (compliant with LGPLv2.1 - no source disclosure required) |
| libpcprofile      | 2.30            | GNU Project  | LGPLv2.1   | Copyright (c) Free Software Foundation |gcc-sigmastar-9.1.0-2020.07-x86_64_arm-linux-gnueabihf https://www.linaro.org/  | Not Modified | Not Applicable | Dynamic linking with proprietary software (compliant with LGPLv2.1 - no source disclosure required) |
| hst016 dtof Drivers    | 1.0.0           | SONY         | BSD-2-Clause / GPL-2.0-only dual license | Copyright (c) SONY Corporation | - | Not Modified | Not Applicable | BSD-2-Clause / GPL-2.0-only dual license, actual license: BSD-2-Clause|
| picojson          | 1.3.0           | Kazuho Oku   | BSD-2-Clause | Copyright (c) 2009-2010 Cybozu Labs, Inc. Copyright (c) 2011-2015 Kazuho Oku | https://github.com/kazuho/picojson | Not Modified | Not Applicable | BSD-2-Clause - proprietary integration allowed with copyright notice preservation |

## License Information

### GNU General Public License v2.0 (GPLv2)
Applies to:
- Linux Kernel 4.9.227
- BusyBox 1.20.2
- U-Boot
- SquashFS
- Buildroot

Key terms:
- You may copy, distribute and modify the software as long as you track changes and disclose the source code
- Any derivative works must also be licensed under GPLv2
- The software is provided "as is" without warranties

### GNU Lesser General Public License v2.1 (LGPLv2.1)
Applies to:
- glibc 2.30

Key terms:
- Allows linking with proprietary software
- Modifications to the library itself must be licensed under LGPLv2.1
- The library is provided "as is" without warranties

### GNU General Public License v3.0 or later (GPLv3+)
Applies to:
- libstdc++ 9.1.0

Key terms:
- You may copy, distribute and modify the software as long as you track changes and disclose the source code
- Any derivative works must also be licensed under GPLv3+
- Includes additional provisions related to user rights and digital restrictions

### Proprietary Licenses
Applies to:
- SigmaStar Drivers
- SONY Software

Key terms:
- These are proprietary software components
- Terms are defined in separate commercial license agreements
- Redistribution and modification rights are restricted

## Copyright Information

### Linux Kernel
Copyright (c) Linux Kernel Organization

### glibc
Copyright (c) Free Software Foundation

### BusyBox
Copyright (c) Various contributors

### U-Boot
Copyright (c) Wolfgang Denk, DENX Software Engineering

### SquashFS
Copyright (c) Phillip Lougher

### Buildroot
Copyright (c) Peter Korsgaard, Yann E. Morin, and others

### libstdc++
Copyright (c) Free Software Foundation

### SigmaStar Drivers
Copyright (c) SigmaStar Technology

### SONY Software
Copyright (c) SONY Corporation

## License Agreements

### GNU General Public License, Version 2

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

### GNU Lesser General Public License, Version 2.1

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

### GNU General Public License, Version 3

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

### SigmaStar Proprietary Software License

The SigmaStar software components are proprietary and confidential.
Use, reproduction, and distribution are subject to a separate
commercial license agreement with SigmaStar Technology.

### SONY Proprietary Software License

The SONY software components are proprietary and confidential.
Use, reproduction, and distribution are subject to a separate
commercial license agreement with SONY Corporation.

## Contact Information

For inquiries regarding open source software compliance, please contact:

Country of Origin: China
Company Name: YUYAO SUNNY OPTICAL INTELLIGENCE TECHNOLOGY CO.,LTD
Address: No. 1898, Shinan West Road, Yuyao City, Ningbo City, Zhejiang Province
Phone: +86-15168337170
Email: zngwyan@sunnyoptical.com
Website: https://www.sunnyaiot.com/

*Note: Source code for all "Modified" GPL components is available for 12 months from product delivery date*

## Proprietary Components

### MI System Libraries
Copyright (c) SigmaStar Technology Ltd. 
These are proprietary software components developed by SigmaStar.
Use, reproduction, and distribution are subject to a separate commercial license agreement.

### MI Algorithm Libraries
Copyright (c) SigmaStar Technology Ltd. 
Includes proprietary algorithms for audio/video processing.
Use, reproduction, and distribution are subject to a separate commercial license agreement.

### MI Codec Libraries
Copyright (c) SigmaStar Technology Ltd. 
Includes proprietary codec implementations.
Use, reproduction, and distribution are subject to a separate commercial license agreement.

## Binary to OSS Mapping

### monitor_app
- **OSS Components**:
  - picojson (BSD-2-Clause) - linked statically
  - glibc-libpthread (LGPLv2.1) - linked dynamically
- **Compliance Verification**:
  - BSD license: Copyright notice preserved in binary
  - LGPL: No modification to library, Dynamic linking with proprietary software (compliant with LGPLv2.1 - no source disclosure required) allowed
  - Source code for picojson available at: https://github.com/kazuho/picojson

### Linux Kernel
- **OSS Components**:
  - Linux Kernel 4.9.227 (GPLv2) - modified
  - libcomposite.ko (GPLv2) - included in kernel
- **Key Modified Files**:
  - `kernel/arch/arm/boot/dts/sony/mercury6.dtsi` (modified platform header)
  - `kernel/arch/arm/boot/dts/sony/mercury6_ssc019a_s01a.dts` (modified board description)
  - `kernel/drivers/sstar/i2c/ms_iic.c`
  - `kernel/drivers/sstar/emac/mdrv_emac.c`
  - `kernel/drivers/usb/gadget/legacy/webcam.c` (modified by Sony Semiconductor Solutions Corporation)
- **Compliance Verification**:
  - Complete modified source code available upon request
  - Build environment provided (defconfig, cross-compiler)
  - Source code disclosure commitment: 12 months from product delivery

### BusyBox
- **OSS Components**:
  - BusyBox 1.20.2 (GPLv2) - not modified
- **Compliance Verification**:
  - Original source available at: https://busybox.net/downloads/
  - No modifications made, no source disclosure required

### U-Boot
- **OSS Components**:
  - U-Boot 2015.1 (GPLv2) - modified
- **Compliance Verification**:
  - Complete modified source code available upon request
  - Build environment provided (cross-compiler, configuration)
  - Source code disclosure commitment: 12 months from product delivery
  - Verified modifications via `git diff 2015.1 -- boot/`
- **Source Code Structure**:
  ```
  boot/
  ├── common/
  ?   └── cmd_nand.c
  ├── configs/
  ?   └── sony_defconfig
  └── drivers/
      └── mstar/
          ├── flash_isp/
          ?   ├── mercury6/
          ?   ?   ├── halSERFLASH.c
          ?   ?   ├── halSERFLASH.h
          ?   ?   └── regSERFLASH.h
          ?   ├── Makefile
          ?   ├── MsCommon.h
          ?   ├── MsDevice.h
          ?   ├── MsIRQ.h
          ?   ├── MsTypes.h
          ?   ├── MsVersion.h
          ?   ├── drvDeviceInfo.c
          ?   ├── drvDeviceInfo.h
          ?   ├── drvSERFLASH.c
          ?   ├── drvSERFLASH.h
          ?   └── mtd_isp.c
          └── spinand/
              ├── hal/
              ?   └── mercury6/
              ?       ├── drvSPINAND_hal.c
              ?       ├── mhal_spinand.c
              ?       ├── mhal_spinand.h
              ?       ├── mhal_spinand_chip_config.c
              ?       └── reg_spinand.h
              ├── inc/
              ?   ├── common/
              ?   ?   ├── drvSPINAND.h
              ?   ?   ├── drvSPINAND_common.h
              ?   ?   ├── halSPINAND.h
              ?   ?   ├── halSPINAND_common.h
              ?   ?   └── spinand.h
              ?   └── config/
              ?       └── mercury6/
              ?           └── drvSPINAND_uboot.h
              ├── Makefile
              ├── drvSPINAND.c
              ├── drvSPINAND_api.c
              ├── drvSPINAND_dev.c
              └── spinand.c
  ```

### dtof_app
- **OSS Components**:
  - picojson (BSD-2-Clause) - linked statically
  - hst016 dtof Drivers (BSD-2-Clause OR GPL-2.0-only) - proprietary integration
- **Compliance Verification**:
  - BSD license: Copyright notice preserved in binary
  - Dual-license declaration: Actual implementation uses BSD-2-Clause
  - Source code for dtof Drivers available via contact email (12 months validity)

## Source Code Package Contents

For GPLv2 components marked as "Modified", the following source code package is available:
```
kernel/
├── drivers/
?   ├── sstar/
?   ?   ├── cam_os_wrapper/
?   ?   ?   └── src/
?   ?   ?       └── cam_os_wrapper.c
?   ?   ├── emac/
?   ?   ?   ├── hal/
?   ?   ?   ?   └── mercury6/
?   ?   ?   ?       ├── mhal_emac.c
?   ?   ?   ?       ├── mhal_emac.h
?   ?   ?   ?       └── mhal_rng_reg.h
?   ?   ?   ├── mdrv_emac.c
?   ?   ?   └── mdrv_emac.h
?   ?   ├── flash_isp/
?   ?   ?   └── mercury6/
?   ?   ?       └── halSERFLASH.c
?   ?   ├── i2c/
?   ?   ?   └── ms_iic.c
?   ?   ├── sdmmc/
?   ?   ?   ├── inc/
?   ?   ?   ?   └── mercury6/
?   ?   ?   ?       ├── hal_card_platform_config.h
?   ?   ?   ?       ├── hal_card_platform_pri_config.h
?   ?   ?   ?       └── hal_card_platform_regs.h
?   ?   ?   ├── src/
?   ?   ?   ?   └── mercury6/
?   ?   ?   ?       └── hal_card_platform.c
?   ?   ?   ├── kdrv_sdmmc.mod.c
?   ?   ?   └── ms_sdmmc_lnx.c
?   ?   └── spinand/
?   ?       ├── drv/
?   ?       ?   ├── mdrv_spinand.c
?   ?       ?   ├── mdrv_spinand.h
?   ?       ?   ├── mdrv_spinand_hal.c
?   ?       ?   └── mdrv_spinand_hal.h
?   ?       └── hal/
?   ?           └── mercury6/
?   ?               ├── mhal_spinand.c
?   ?               ├── mhal_spinand.h
?   ?               ├── mhal_spinand_chip_config.c
?   ?               └── reg_spinand.h
?   └── usb/
?       └── gadget/
?           ├── function/
?           ?   └── uvc_v4l2.c
?           └── legacy/
?               └── webcam.c
├── arch/
?   └── arm/
?       └── boot/
?           └── dts/
?               └── mercury6.dtsi             
```

### Linux Kernel Build Instructions
1. **Prerequisites**:
   - Cross-compiler: `arm-linux-gnueabihf-sigmastar-9.1.0-`
   - Build tools: `make`, `git`
   
2. **Build Process**:
   ```bash
   # Change to kernel directory
   cd kernel
   
   # Set environment variables
   export ARCH=arm
   export CROSS_COMPILE=arm-linux-gnueabihf-sigmastar-9.1.0-
   
   # Apply USB configurations
   ./add_rndis.sh mercury6_ssc019a_s01a_spinand_usbcam_defconfig
   
   # Configure kernel
   make mercury6_ssc019a_s01a_spinand_usbcam_defconfig
   
   # Clean previous build
   make clean
   
   # Build kernel image and modules
   make -j32
   
   # Copy output to images directory
   cp arch/arm/boot/uImage.xz ../images/kernel
   ```
   
   Where add_rndis.sh contains:
   ```bash
   #!/bin/sh
   sed -i '/CONFIG_SS_GADGET/a\CONFIG_USB_U_ETHER=m' ./arch/arm/configs/$1
   sed -i '/CONFIG_USB_U_AUDIO/a\CONFIG_USB_F_RNDIS=m' ./arch/arm/configs/$1
   sed -i 's/# CONFIG_USB_WEBCAM_RNDIS is not set/CONFIG_USB_WEBCAM_RNDIS=y/' ./arch/arm/configs/$1
   ```
   

### U-Boot Build Instructions
1. **Prerequisites**:
   - Cross-compiler: `arm-linux-gnueabihf-sigmastar-9.1.0-`
   - Build tools: `make`, `git`
   
2. **Build Process**:
   ```bash
   # Change to boot directory
   cd boot
   
   # Set environment variables
   export ARCH=arm
   export CROSS_COMPILE=arm-linux-gnueabihf-sigmastar-9.1.0-
   
   # Configure U-Boot
   make mercury6_spinand_defconfig
   
   # Clean previous build
   make clean
   
   # Build U-Boot
   make -j12
   ```